package com.ptp.ptplatform.service.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.*;
import com.turn.ttorrent.common.PeerUID;
import java.io.IOException;
import java.net.InetSocketAddress;

public class PeerUIDSerializer extends JsonSerializer<PeerUID> {
    @Override
    public void serialize(PeerUID peerUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider)
            throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("torrentHash", peerUID.getTorrentHash());

        // 序列化 InetSocketAddress
        InetSocketAddress address = peerUID.getAddress();
        jsonGenerator.writeObjectFieldStart("address");
        jsonGenerator.writeStringField("host", address.getHostString());
        jsonGenerator.writeNumberField("port", address.getPort());
        jsonGenerator.writeEndObject();

        jsonGenerator.writeEndObject();
    }
}

