package com.ptp.ptplatform.utils;

import java.util.*;

public class SimilarityUtil {

    /**
     * 计算用户相似度 (余弦相似度)
     */
    public static double calculateUserSimilarity(Map<Integer, Integer> user1Downloads,
                                                 Map<Integer, Integer> user2Downloads) {
        Set<Integer> commonTorrents = new HashSet<>(user1Downloads.keySet());
        commonTorrents.retainAll(user2Downloads.keySet());

        if (commonTorrents.isEmpty()) return 0.0;

        double dotProduct = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;

        // 计算共同下载的种子的点积和范数
        for (Integer torrentId : commonTorrents) {
            dotProduct += user1Downloads.get(torrentId) * user2Downloads.get(torrentId);
        }

        // 计算用户1的范数
        for (Integer count : user1Downloads.values()) {
            norm1 += Math.pow(count, 2);
        }

        // 计算用户2的范数
        for (Integer count : user2Downloads.values()) {
            norm2 += Math.pow(count, 2);
        }

        return dotProduct / (Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    /**
     * 计算种子相似度 (基于共同下载用户)
     */
    public static double calculateTorrentSimilarity(Set<Integer> torrent1Users,
                                                    Set<Integer> torrent2Users) {
        Set<Integer> intersection = new HashSet<>(torrent1Users);
        intersection.retainAll(torrent2Users);

        Set<Integer> union = new HashSet<>(torrent1Users);
        union.addAll(torrent2Users);

        if (union.isEmpty()) return 0.0;

        return (double) intersection.size() / union.size();
    }
}