package com.ptp.ptplatform.utils;

import com.ptp.ptplatform.entity.DISCOUNT;
import com.ptp.ptplatform.mapper.DiscountMapper;

import java.time.Duration;
import java.time.LocalDateTime;

//实现将字节大小转化为GB
public class SizeCalculation {

    public static int byteToGB(long bytes) {
        return (int) (bytes / 1024 / 1024 / 1024);
    }
    public static long GBToByte(long GB) { return (long) (GB * 1024 * 1024 * 1024); }

    public static long getUpload(long uploaded, DiscountMapper discountMapper, LocalDateTime torrentTime) {
        // 计算折扣
        DISCOUNT discount = discountMapper.selectCurrentDiscount();
        if (Duration.between(torrentTime, LocalDateTime.now()).toDays() <= 7) {
            uploaded = uploaded * 2;
        }
        if (discount != null) {
            if (discount.getDiscountType().equals("DOUBLE")) {
                uploaded = 2 * uploaded;
            }
        }

        return uploaded;
    }

    public static long getDownload(long downloaded, DiscountMapper discountMapper, LocalDateTime torrentTime) {
        DISCOUNT discount = discountMapper.selectCurrentDiscount();
        if (Duration.between(torrentTime, LocalDateTime.now()).toDays() <= 7) {
            downloaded = downloaded / 2;
        }
        if (discount != null) {
            if (discount.getDiscountType().equals("FREE")) {
                downloaded = 0;
            } else if (discount.getDiscountType().equals("HALF")) {
                downloaded = downloaded / 2;
            }
        }
        return downloaded;
    }
}
