package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.entity.DISCOUNT;
import com.ptp.ptplatform.mapper.DiscountMapper;
import com.ptp.ptplatform.utils.Result;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.ResponseEntity;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

@SpringBootTest
public class DiscountControllerTest {

    @Mock
    private DiscountMapper discountMapper;

    @InjectMocks
    private DiscountController discountController;

    private DISCOUNT discount;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks(this);
        discount = new DISCOUNT("五一节日", LocalDateTime.now().plusDays(1), LocalDateTime.now().plusDays(10), "HALF");
    }

    @Test
    public void testAddDiscount_Success() {
        // Mock the insert method to return 1 (success)
        when(discountMapper.insertDiscount(discount)).thenReturn(1);

        Result result = discountController.addDiscount(discount);

        assertNotNull(result);
        assertEquals(200, result.getCode());
        verify(discountMapper, times(1)).insertDiscount(discount);
    }

    @Test
    public void testAddDiscount_Failure_DuplicateTime() {
        // Mock the checkOverlapTime method to return > 0 (overlap found)
        when(discountMapper.checkOverlapTime(discount.getStartTime(), discount.getEndTime())).thenReturn(1);

        Result result = discountController.addDiscount(discount);

        assertNotNull(result);
        assertEquals(500, result.getCode());
        assertEquals("新折扣时间与已有折扣时间重叠，请选择不同时间。", result.getMessage());
    }

    @Test
    public void testDeleteDiscount_Success() {
        // Mock the delete method to return 1 (success)
        when(discountMapper.deleteDiscountById(1)).thenReturn(1);

        Result result = discountController.deleteDiscount(1);

        assertNotNull(result);
        assertEquals(200, result.getCode());
        assertEquals("删除成功。", result.getMessage());
        verify(discountMapper, times(1)).deleteDiscountById(1);
    }

    @Test
    public void testDeleteDiscount_Failure_NotFound() {
        // Mock the delete method to return 0 (failure)
        when(discountMapper.deleteDiscountById(1)).thenReturn(0);

        Result result = discountController.deleteDiscount(1);

        assertNotNull(result);
        assertEquals(500, result.getCode());
        assertEquals("折扣未找到。", result.getMessage());
    }

    @Test
    public void testGetCurrentDiscount_Success() {
        // Mock the selectCurrentDiscount method to return a discount
        when(discountMapper.selectCurrentDiscount()).thenReturn(discount);

        Result result = discountController.getCurrentDiscount();

        assertNotNull(result);
        assertEquals(200, result.getCode());
        assertEquals(discount, result.getData().get("data"));
    }

    @Test
    public void testGetAllDiscounts_Success() {
        // Mock the selectAllDiscounts method to return a list of discounts
        when(discountMapper.selectAllDiscounts()).thenReturn(Collections.singletonList(discount));

        Result result = discountController.getAllDiscounts();

        assertNotNull(result);
        assertEquals(200, result.getCode());
        assertTrue(result.getData().get("data") instanceof List);
        assertEquals(1, ((List) result.getData().get("data")).size());
    }
}
