package com.ptp.ptplatform.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ptp.ptplatform.entity.TORRENT;
import com.ptp.ptplatform.entity.TorrentComment;
import com.ptp.ptplatform.service.TorrentCommentService;
import com.ptp.ptplatform.service.TorrentService;
import com.ptp.ptplatform.utils.Result;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

class TORRENTControllerTest {

    @Mock
    private TorrentService torrentService;

    @Mock
    private TorrentCommentService commentService;

    @InjectMocks
    private TorrentController torrentController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void getTorrentById_ShouldReturnTorrent_WhenTorrentExists() {
        // 1. 使用构造函数创建测试数据
        TORRENT mockTORRENT = new TORRENT(
                "d3b07384d113edec49eaa6238ad5ff00", // hash
                "Ubuntu 22.04 ISO",                // torrentName
                "Official Ubuntu Linux distribution", // description
                "Software",                        // category
                "美国",                            // region
                "1080p",                          // resolution
                "中文字幕",                        // subtitle
                2048L,                            // size (2GB)
                "admin",                          // username
                "/downloads/ubuntu-22.04.iso"      // filePath
        );
        mockTORRENT.setId(1);
        mockTORRENT.setLike_count(200);
        mockTORRENT.setReply_count(10);
        mockTORRENT.setCreateTime(LocalDateTime.now());

        // 模拟空评论列表
        List<TorrentComment> emptyComments = new ArrayList<>();

        // 2. 模拟服务层行为
        when(torrentService.getById(1)).thenReturn(mockTORRENT);
        when(commentService.list(any(QueryWrapper.class))).thenReturn(emptyComments);

        // 3. 调用控制器方法
        Result result = torrentController.getPost(1);

        // 4. 验证结果
        assertEquals(200, result.getCode());
        assertNotNull(result.getData().get("torrent"));

        // 获取返回的Map对象
        Map<String, Object> torrentMap = (Map<String, Object>) result.getData().get("torrent");

        // 验证Map中的值
        assertEquals("Ubuntu 22.04 ISO", torrentMap.get("torrentName"));
        assertEquals(200, torrentMap.get("like_count"));
        assertEquals(10, torrentMap.get("reply_count"));
        assertEquals("Software", torrentMap.get("category"));
        assertEquals("美国", torrentMap.get("region"));
        assertEquals("1080p", torrentMap.get("resolution"));
        assertEquals("中文字幕", torrentMap.get("subtitle"));
        assertEquals("admin", torrentMap.get("username"));
        assertEquals("/downloads/ubuntu-22.04.iso", torrentMap.get("filePath"));

        // 5. 验证服务层调用
        verify(torrentService, times(1)).getById(1);
        verify(commentService, times(1)).list(any(QueryWrapper.class));
    }
}