// jest.config.js
module.exports = {
  "testEnvironment": "jsdom",
  "setupFilesAfterEnv": ["@testing-library/jest-dom/extend-expect"],
  moduleNameMapper: {
    '^@/(.*)$': '<rootDir>/src/$1',
    '\\.(css|less|scss|sass)$': 'identity-obj-proxy',
  },
  transform: {
    '^.+\\.(js|jsx)$': 'babel-jest',
  },
  transformIgnorePatterns: [
    'node_modules/(?!(your-esm-modules)/)'
  ],
  collectCoverageFrom: [
    'src/components/**/*.{js,jsx}',
    '!src/components/**/*.stories.js',
    '!src/components/**/index.js'
  ],
  coverageThreshold: {
    global: {
      branches: 80,
      functions: 80,
      lines: 80,
      statements: 80
    }
  },
  setupFilesAfterEnv: ['./jest.setup.js'],
  globals: {
    'process.env': {
      NODE_ENV: 'test',
      VITE_API_BASE_URL: 'http://test-api'
    }
  }
};
