// src/App.jsx
import React from 'react';
import { 
  BrowserRouter as Router,
  Routes,
  Route,
  Navigate
} from 'react-router-dom';
import Dashboard from './components/Dashboard';
import Personal from './components/Personal/Personal';
import AuthForm from './components/AuthForm';
import AnnouncementDetail from './components/AnnouncementDetail';

import TorrentDetail from './components/TorrentDetail'; // 确保路径正确
import RequestDetail from './components/RequestDetail';
import HelpDetail from './components/HelpDetail';
import Exchange from './components/Personal/Exchange';
import Upload from './components/Personal/Upload';
import Notice from './components/Personal/Notice';
import Setting from './components/Personal/Setting';
import Administer from './components/Administer';

import './App.css';

function App() {
  // 每次应用启动时强制清除 token
  React.useEffect(() => {
    localStorage.removeItem('token');
    console.log('Token cleared on app startup');
    localStorage.removeItem('username');
  }, []); // 空依赖数组表示只在组件挂载时执行一次

  const [isAuthenticated, setIsAuthenticated] = React.useState(
    false
  );

  const handleLoginSuccess = (token) => {
    setIsAuthenticated(true);
  };

  const handleLogout = () => {
    localStorage.removeItem('token');
    setIsAuthenticated(false);
  };

  return (
    <Router>
      <Routes>
        {/* 修改点1：根路径强制跳转到登录页 */}
        <Route path="/" element={<Navigate to="/login" replace />} />

        {/* 登录页 */}
        <Route path="/login" element={
          isAuthenticated ? (
            <Navigate to="/dashboard" replace />
          ) : (
            <AuthForm onLoginSuccess={handleLoginSuccess} />
          )
        } />

        {/* 主面板 */}
        <Route path="/dashboard/:tab?" element={
          isAuthenticated ? (
            <Dashboard onLogout={handleLogout} />
          ) : (
            <Navigate to="/login" replace />
          )
        } />

        {/* 公告详情 */}
        <Route path="/announcement/:id" element={
          isAuthenticated ? (
            <AnnouncementDetail onLogout={handleLogout} />
          ) : (
            <Navigate to="/login" replace />
          )
        } />

        {/* 个人中心及子功能页面 */}
        <Route path="/personal" element={
          isAuthenticated ? <Personal onLogout={handleLogout} /> : <Navigate to="/login" replace />
        } />
        <Route path="/personal/exchange" element={
          isAuthenticated ? <Exchange onLogout={handleLogout} /> : <Navigate to="/login" replace />
        } />
        <Route path="/personal/upload" element={
          isAuthenticated ? <Upload onLogout={handleLogout} /> : <Navigate to="/login" replace />
        } />
        <Route path="/personal/notice" element={
          isAuthenticated ? <Notice onLogout={handleLogout} /> : <Navigate to="/login" replace />
        } />
        <Route path="/personal/setting" element={
          isAuthenticated ? <Setting onLogout={handleLogout} /> : <Navigate to="/login" replace />
        } />

        
        {/* 404 重定向 */}
        <Route path="*" element={
          isAuthenticated ? (
            <Navigate to="/dashboard" replace />
          ) : (
            <Navigate to="/login" replace />
          )
        } />

        {/* 新增管理员中心路由 */}
        <Route path="/administer" element={
          isAuthenticated ? (
            <Administer onLogout={handleLogout} />
          ) : (
            <Navigate to="/login" replace />
          )
        } />

        {/* 求种区 */}
        <Route path="/request/:id" element={
          isAuthenticated ? (
            <RequestDetail onLogout={handleLogout} />
          ) : (
            <Navigate to="/login" replace />
          )
        } />

        {/* 求助区 */}
        <Route path="/help/:id" element={
          isAuthenticated ? (
            <HelpDetail onLogout={handleLogout} />
          ) : (
            <Navigate to="/login" replace />
          )
        } />

        <Route path="/torrent/:id" element={
          isAuthenticated ? (
            <TorrentDetail onLogout={handleLogout} />
          ) : (
            <Navigate to="/login" replace />
          )
        } />



      </Routes>

      
    </Router>
  );
}

export default App;