import { api } from './auth';

// 获取所有公告
export const getAnnouncements = async () => {
  const response = await api.get('/announcement/list');
  return response.data.data.announcements; // 提取嵌套的公告数组
};

export const postAnnouncement = (data) => {
  // 创建 FormData 对象
  const formData = new FormData();
  formData.append('title', data.title);
  formData.append('content', data.content);

  return api.post('/announcement/create', formData);
}


// 获取最新公告
export const getLatestAnnouncements = () => {
  return api.get('/announcement/latest');
};

// 获取公告详情
export const getAnnouncementDetail = (id) => {
  return api.get(`/announcement/${id}`);
};

