// src/api/auth.js
import axios from 'axios';

// 创建并导出 axios 实例
export const api = axios.create({
  baseURL: 'http://localhost:8088',
  timeout: 5000,
});

// 请求拦截器
api.interceptors.request.use(config => {
  const token = localStorage.getItem('token');
  if (token) {
    config.headers.Authorization = `Bearer ${token}`;
  }
  return config;
});

export const login = async (username, password) => {
  const response = await api.post('/user/login', null, {
    params: { username, password }
  });
  if (response.data.code === 200 && response.data.data.token) {
    localStorage.setItem('token', response.data.data.token);
  }
  return response;
};

export const register = (username, password, code) => {
  return api.post('/user/regist', null, {
    params: { username, password, code }
  });
};

export const getUserInfo = async () => {
  try {
    const response = await api.get('/user/userInfo');
    if (response.data.code === 200) {
      return response.data.data; 
    }
    throw new Error(response.data.message || '获取用户信息失败');
  } catch (error) {
    console.error('获取用户信息失败:', error);
    throw error;
  }
};

export const isAdmin = async () => {
  try {
    const userInfo = await getUserInfo();
    return userInfo.authority === 'ADMIN';
  } catch (error) {
    console.error('检查管理员权限失败:', error);
    return false;
  }
};
