import { api } from './auth';

export const likeHelpPostComment = (commentId) => {
  return api.post(`/help/comments/${commentId}/like`);
};

export const getHelpCommentReplies = (commentId) => {
  return api.get(`/help/comments/${commentId}/replies`);
};

export const addHelpCommentReply = (commentId, replyData) => {
  const formData = new FormData();
  formData.append('authorId', replyData.authorId);
  formData.append('content', replyData.content);

  // 如果有图片，添加到formData
  if (replyData.image) {
    formData.append('image', replyData.image);
  }

  return api.post(`/help/comments/${commentId}/replies`, formData);
};

export const deleteHelpComment = (commentId, authorId) => {
  return api.delete(`/help/comments/${commentId}`, {
    params: { authorId }
  });
};