// src/api/helpPost.js
import { api } from './auth'; // 复用已有的axios实例

export const createHelpPost = (title, content, authorId, selectedImage) => {
  // 创建 FormData 对象
  const formData = new FormData();
  formData.append('title', title);
  formData.append('content', content);
  formData.append('authorId', authorId);
  
  // 如果有图片，添加到 FormData
  if (selectedImage) {
    formData.append('image', selectedImage);
  }

  return api.post('/help/posts', formData);
};

export const getHelpPosts = (page = 1, size = 5) => {
  return api.get('/help/posts', {
    params: { page, size }
  });
};

export const getHelpPostDetail = (postId) => {
  return api.get(`/help/posts/${postId}`);
};

export const likeHelpPost = (postId, data) => {
  return api.post(`/help/posts/${postId}/like`, null, {
    params: data
  });
};

export const addHelpPostComment = (postId, commentData) => {
  

  return api.post(`/help/posts/${postId}/comments`, commentData);
};

export const deleteHelpPost = (postId, authorId) => {
  return api.delete(`/help/posts/${postId}`, {
    params: { authorId }
  });
};


export const searchHelpPosts = (keyword, page = 1, size = 5) => {
  return api.get('/help/posts/search', {
    params: { keyword, page, size }
  });
};