// src/api/notification.js
import axios from 'axios';
import { api } from './auth';



export const notificationApi = {
  // 获取用户通知列表
  async getNotifications(userId) {
    try {
      const response = await api.get(`/api/notifications`, {
        params: { userId }
      });
      return response.data;
    } catch (error) {
      console.error('获取通知列表失败:', error);
      throw error;
    }
  },

  // 标记通知为已读 - 更新为处理返回的notification对象
  async markNotificationAsRead(notificationId) {
    try {
      const response = await api.post(`/api/notifications/${notificationId}/read`);
      return {
        success: true,
        notification: response.data.notification // 获取后端返回的更新后通知
      };
    } catch (error) {
      console.error('标记通知为已读失败:', error);
      return {
        success: false,
        message: error.response?.data?.message || '标记已读失败'
      };
    }
  }
};