import MockAdapter from 'axios-mock-adapter';
import { api } from './auth';
import { notificationApi } from './notification';

describe('通知API', () => {
  let mockAxios;

  beforeEach(() => {
    mockAxios = new MockAdapter(api);
  });

  afterEach(() => {
    mockAxios.restore();
  });

  describe('getNotifications - 获取通知列表', () => {
    it('应该成功获取用户通知列表', async () => {
      const userId = 'user123';
      const mockData = [
        { id: '1', message: '通知1', read: false },
        { id: '2', message: '通知2', read: true }
      ];
      
      mockAxios.onGet('/api/notifications', { params: { userId } })
        .reply(200, mockData);

      const response = await notificationApi.getNotifications(userId);
      expect(response).toEqual(mockData);
    });

    
  });

  describe('markNotificationAsRead - 标记通知为已读', () => {
    it('应该成功发送标记请求', async () => {
      const notificationId = 'notif123';
      const mockResponse = { success: true };
      
      mockAxios.onPost(`/api/notifications/${notificationId}/read`)
        .reply(200, mockResponse);

      const response = await notificationApi.markNotificationAsRead(notificationId);
      expect(response).toEqual(mockResponse);
    });

    
  });
});