// src/api/recommend.js
import { api } from './auth';

export const getRecommendations = async (limit = 5) => {
  try {
    const response = await api.get('/recommend/for-user', {
      params: { limit }
    });
    console.log("recommendations response", response);
    return response.data;
  } catch (error) {
    console.error('获取推荐失败:', error);
    throw error;
  }
};

export const markRecommendationShown = async (torrentId) => {
  try {
    await api.post(`/recommend/mark-shown/${torrentId}`);
  } catch (error) {
    console.error('标记推荐为已显示失败:', error);
  }
};

export const markRecommendationClicked = async (torrentId) => {
  try {
    await api.post(`/recommend/mark-clicked/${torrentId}`);
  } catch (error) {
    console.error('标记推荐为已点击失败:', error);
  }
};