import { api } from './auth';

export const likeRequestPostComment = (commentId) => {
  return api.post(`/request/comments/${commentId}/like`);
};

export const getRequestCommentReplies = (commentId) => {
  return api.get(`/request/comments/${commentId}/replies`);
};

export const addRequestCommentReply = (commentId, replyData) => {
  const formData = new FormData();
  formData.append('authorId', replyData.authorId);
  formData.append('content', replyData.content);

  // 如果有图片，添加到formData
  if (replyData.image) {
    formData.append('image', replyData.image);
  }

  return api.post(`/request/comments/${commentId}/replies`, formData);
};

export const deleteRequestComment = (commentId, authorId) => {
  return api.delete(`/request/comments/${commentId}`, {
    params: { authorId }
  });
};