// src/api/requestPost.js
import { api } from './auth'; // 复用已有的axios实例

export const createRequestPost = (title, content, authorId, selectedImage) => {
  // 创建 FormData 对象
  const formData = new FormData();
  formData.append('title', title);
  formData.append('content', content);
  formData.append('authorId', authorId);
  
  // 如果有图片，添加到 FormData
  if (selectedImage) {
    formData.append('image', selectedImage);
  }

  return api.post('/request/posts', formData);
};

export const getRequestPosts = (page = 1, size = 5) => {
  return api.get('/request/posts', {
    params: { page, size }
  });
};

export const getRequestPostDetail = (postId) => {
  return api.get(`/request/posts/${postId}`);
};

export const likeRequestPost = (postId, data) => {
  return api.post(`/request/posts/${postId}/like`, null, {
    params: data
  });
};

export const addRequestPostComment = (postId, commentData) => {
  

  return api.post(`/request/posts/${postId}/comments`, commentData);
};

export const deleteRequestPost = (postId, authorId) => {
  return api.delete(`/request/posts/${postId}`, {
    params: { authorId }
  });
};


export const searchRequestPosts = (keyword, page = 1, size = 5) => {
  return api.get('/request/posts/search', {
    params: { keyword, page, size }
  });
};