import MockAdapter from 'axios-mock-adapter';
import { api } from './auth'; // 添加api导入
import { likeTorrentComment, getCommentReplies, addCommentReply } from './torrentComment';

describe('种子评论API', () => {
  let mockAxios;

  beforeEach(() => {
    mockAxios = new MockAdapter(api);
  });

  afterEach(() => {
    mockAxios.restore();
  });

  describe('likeTorrentComment - 点赞种子评论', () => {
    it('应该成功发送点赞请求', async () => {
      const commentId = '123';
      const mockResponse = { code: 200, message: '点赞成功' };
      
      mockAxios.onPost(`/torrent/comments/${commentId}/like`).reply(200, mockResponse);

      const response = await likeTorrentComment(commentId);
      expect(response.data).toEqual(mockResponse);
    });

    it('应该处理点赞失败的情况', async () => {
      mockAxios.onPost('/torrent/comments/123/like').reply(500);
      await expect(likeTorrentComment('123')).rejects.toThrow();
    });
  });

  describe('getCommentReplies - 获取评论回复', () => {
    it('应该成功获取回复列表', async () => {
      const commentId = '456';
      const mockResponse = {
        code: 200,
        data: [{ id: '1', content: '回复1' }, { id: '2', content: '回复2' }]
      };
      
      mockAxios.onGet(`/torrent/comments/${commentId}/replies`).reply(200, mockResponse);

      const response = await getCommentReplies(commentId);
      expect(response.data).toEqual(mockResponse);
    });
  });

  describe('addCommentReply - 添加评论回复', () => {
    it('应该成功添加回复', async () => {
      const commentId = '789';
      const replyData = { content: '测试回复' };
      const mockResponse = { code: 200, data: { id: '3', ...replyData } };
      
      mockAxios.onPost(`/torrent/comments/${commentId}/replies`, replyData).reply(200, mockResponse);

      const response = await addCommentReply(commentId, replyData);
      expect(response.data).toEqual(mockResponse);
    });
  });
});