import { request } from '@umijs/max';
import type {
    RewardItem,
    RewardListParams,
} from '@/pages/Reward/data'; // 假设你把 data.d.ts 放这里

/** 获取悬赏任务列表 */
export async function getRewardList(params?: RewardListParams) {
    const queryString = params
        ? `?${new URLSearchParams(params as Record<string, any>).toString()}`
        : '';
    const response = await request(`/api/reward/list${queryString}`, {
        method: 'get',
    });
    if (!response || response.length === 0) {
        return [{ id: 1, name: '虚假任务1', description: '这是一个虚假的任务描述' }, { id: 2, name: '虚假任务2', description: '这是另一个虚假的任务描述' }];
    }
    return response;
}

/** 获取悬赏任务详细信息 */
export async function getReward(rewardId: number) {
    return request(`/api/reward/${rewardId}`, {
        method: 'get',
    });
}

/** 新增悬赏任务 */
export async function addReward(params: RewardItem) {
    return request('/api/reward', {
        method: 'post',
        data: params,
    });
}

/** 修改悬赏任务 */
export async function updateReward(params: RewardItem) {
    return request('/api/reward', {
        method: 'put',
        data: params,
    });
}

/** 删除悬赏任务 */
export async function removeReward(ids: string) {
    return request(`/api/reward/${ids}`, {
        method: 'delete',
    });
}