import { request } from '@umijs/max';
import type { SysTorrentComment } from '@/pages/Torrent/Comments/data';

/** 获取种子评论列表 */
export async function listComments(torrentId: number) {
    return request<SysTorrentComment[]>(`/api/system/torrent/comment/list`, {
        method: 'get',
        params: { torrentId },
    });
}

/** 新增评论 */
export async function addComment(data: {
    torrentId: number;
    userId: number;
    content: string;
    parentId?: number;
}) {
    return request(`/api/system/torrent/comment`, {
        method: 'post',
        data,
    });
}

/** 删除评论 */
export async function deleteComment(commentId: number) {
    return request(`/api/system/torrent/comment/${commentId}`, {
        method: 'delete',
    });
}
