

/** 种子主表 */
export interface BtTorrent {
  /** 种子ID */
  torrentId: number;
  /** InfoHash */
  infoHash: string;
  /** 种子名称 */
  name: string;
  /** 总大小（字节） */
  length: number;
  /** 每个 piece 的长度 */
  pieceLength: number;
  /** piece 总数 */
  piecesCount: number;
  /** 创建工具（如 qBittorrent） */
  createdBy: string;
  /** .torrent 内的创建时间 */
  torrentCreateTime: Date | null;
  /** 上传用户ID（sys_user.userId） */
  uploaderId: number;
  /** 上传时间 */
  uploadTime: Date;
  /** 种子文件存储路径（服务器端路径或 URL） */
  filePath: string;
}

/** 种子文件列表 */
export interface BtTorrentFile {
  /** 文件记录ID */
  id: number;
  /** 种子ID */
  torrentId: number;
  /** 文件路径 */
  filePath: string;
  /** 文件大小 */
  fileSize: number;
}

/** announce 列表 */
export interface BtTorrentAnnounce {
  /** ID */
  id: number;
  /** 种子ID */
  torrentId: number;
  /** Tracker URL */
  announceUrl: string;
}

/** 标签表（可选） */
export interface BtTorrentTag {
  /** ID */
  id: number;
  /** 种子ID */
  torrentId: number;
  /** 标签内容 */
  tag: string;
}
