import { request } from '@umijs/max';
import type {
  BtTorrent,
  BtTorrentFile,
  BtTorrentAnnounce,
  BtTorrentTag,
} from '@/pages/Torrent/data'; // 假设你把 data.d.ts 放这里

/** 下载种子文件 */
export async function downloadTorrent(torrentId: number) {
  return request(`/api/system/torrent/download/${torrentId}`, {
    method: 'get',
    responseType: 'blob',
  });
}

// ================================
// 种子主表（bt_torrent）接口
// ================================

/** 查询种子列表 */
export async function listBtTorrent(params?: Partial<BtTorrent>) {
  const queryString = params ? `?${new URLSearchParams(params as any)}` : '';
  return request(`/api/system/torrent/list${queryString}`, {
    method: 'get',
  });
}

/** 获取种子详情 */
export async function getBtTorrent(torrentId: number) {
  return request<BtTorrent>(`/api/system/torrent/${torrentId}`, {
    method: 'get',
  });
}

/** 新增种子 */
export async function addBtTorrent(data: BtTorrent) {
  return request('/api/system/torrent', {
    method: 'post',
    data,
  });
}

/** 修改种子 */
export async function updateBtTorrent(data: BtTorrent) {
  return request('/api/system/torrent', {
    method: 'put',
    data,
  });
}

/** 删除种子（支持批量） */
export async function removeBtTorrent(torrentIds: number[]) {
  return request(`/api/system/torrent/${torrentIds.join(',')}`, {
    method: 'delete',
  });
}

// ================================
// 种子文件（bt_torrent_file）接口
// ================================

/** 查询种子文件列表 */
export async function listBtTorrentFile(params?: Partial<BtTorrentFile>) {
  const queryString = params ? `?${new URLSearchParams(params as any)}` : '';
  return request(`/api/system/file/list${queryString}`, {
    method: 'get',
  });
}

/** 获取文件详情 */
export async function getBtTorrentFile(id: number) {

  return request<BtTorrentFile>(`/api/system/file/${id}`, {
    method: 'get',
  });
}

/** 新增文件 */
export async function addBtTorrentFile(data: BtTorrentFile) {
  return request('/api/system/file', {
    method: 'post',
    data,
  });
}

/** 修改文件 */
export async function updateBtTorrentFile(data: BtTorrentFile) {
  return request('/api/system/file', {
    method: 'put',
    data,
  });
}

/** 删除文件（支持批量） */
export async function removeBtTorrentFile(ids: number[]) {
  return request(`/api/system/file/${ids.join(',')}`, {
    method: 'delete',
  });
}

// ================================
// Tracker 列表（bt_torrent_announce）接口
// ================================

/** 查询 Tracker 列表 */
export async function listBtTorrentAnnounce(params?: Partial<BtTorrentAnnounce>) {
  const queryString = params ? `?${new URLSearchParams(params as any)}` : '';
  return request(`/api/system/announce/list${queryString}`, {
    method: 'get',
  });
}

/** 获取单个 Tracker */
export async function getBtTorrentAnnounce(id: number) {
  return request<BtTorrentAnnounce>(`/api/system/announce/${id}`, {
    method: 'get',
  });
}

/** 新增 Tracker */
export async function addBtTorrentAnnounce(data: BtTorrentAnnounce) {
  return request('/api/system/announce', {
    method: 'post',
    data,
  });
}

/** 修改 Tracker */
export async function updateBtTorrentAnnounce(data: BtTorrentAnnounce) {
  return request('/api/system/announce', {
    method: 'put',
    data,
  });
}

/** 删除 Tracker（支持批量） */
export async function removeBtTorrentAnnounce(ids: number[]) {
  return request(`/api/system/announce/${ids.join(',')}`, {
    method: 'delete',
  });
}

// ================================
// 种子标签（bt_torrent_tags）接口
// ================================

/** 查询标签列表 */
export async function listBtTorrentTags(params?: Partial<BtTorrentTag>) {
  const queryString = params ? `?${new URLSearchParams(params as any)}` : '';
  return request(`/api/system/tags/list${queryString}`, {
    method: 'get',
  });
}

/** 获取标签详情 */
export async function getBtTorrentTag(id: number) {
  return request<BtTorrentTag>(`/api/system/tags/${id}`, {
    method: 'get',
  });
}

/** 新增标签 */
export async function addBtTorrentTag(data: BtTorrentTag) {
  return request('/api/system/tags', {
    method: 'post',
    data,
  });
}

/** 修改标签 */
export async function updateBtTorrentTag(data: BtTorrentTag) {
  return request('/api/system/tags', {
    method: 'put',
    data,
  });
}
/**
 * 上传并解析种子文件
 * @param file The .torrent file to upload
 * @returns The parsed torrent data or error message
 */
export async function uploadTorrent(file: File) {
  const formData = new FormData();
  formData.append('file', file);

  return request('/api/system/torrent/uploadTorrent', {
    method: 'POST',
    data: formData,
    headers: {
      'Content-Type': 'multipart/form-data',
    },
  });
}
/** 删除标签（支持批量） */
export async function removeBtTorrentTag(ids: number[]) {
  return request(`/api/system/tags/${ids.join(',')}`, {
    method: 'delete',
  });
}
