package com.ruoyi.torrent.controller;

import java.util.List;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.torrent.domain.BtTorrentFile;
import com.ruoyi.torrent.service.IBtTorrentFileService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 种子包含的文件列Controller
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@RestController
@RequestMapping("/system/file")
public class BtTorrentFileController extends BaseController
{
    @Autowired
    private IBtTorrentFileService btTorrentFileService;

    /**
     * 查询种子包含的文件列列表
     */
    @PreAuthorize("@ss.hasPermi('system:file:list')")
    @GetMapping("/list")
    public TableDataInfo list(BtTorrentFile btTorrentFile)
    {
        startPage();
        List<BtTorrentFile> list = btTorrentFileService.selectBtTorrentFileList(btTorrentFile);
        return getDataTable(list);
    }

    /**
     * 导出种子包含的文件列列表
     */
    @PreAuthorize("@ss.hasPermi('system:file:export')")
    @Log(title = "种子包含的文件列", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BtTorrentFile btTorrentFile)
    {
        List<BtTorrentFile> list = btTorrentFileService.selectBtTorrentFileList(btTorrentFile);
        ExcelUtil<BtTorrentFile> util = new ExcelUtil<BtTorrentFile>(BtTorrentFile.class);
        util.exportExcel(response, list, "种子包含的文件列数据");
    }

    /**
     * 获取种子包含的文件列详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:file:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(btTorrentFileService.selectBtTorrentFileById(id));
    }

    /**
     * 新增种子包含的文件列
     */
    @PreAuthorize("@ss.hasPermi('system:file:add')")
    @Log(title = "种子包含的文件列", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BtTorrentFile btTorrentFile)
    {
        return toAjax(btTorrentFileService.insertBtTorrentFile(btTorrentFile));
    }

    /**
     * 修改种子包含的文件列
     */
    @PreAuthorize("@ss.hasPermi('system:file:edit')")
    @Log(title = "种子包含的文件列", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BtTorrentFile btTorrentFile)
    {
        return toAjax(btTorrentFileService.updateBtTorrentFile(btTorrentFile));
    }

    /**
     * 删除种子包含的文件列
     */
    @PreAuthorize("@ss.hasPermi('system:file:remove')")
    @Log(title = "种子包含的文件列", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(btTorrentFileService.deleteBtTorrentFileByIds(ids));
    }
}
