package com.ruoyi.torrent.controller;

import java.util.List;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.torrent.domain.BtTorrentTags;
import com.ruoyi.torrent.service.IBtTorrentTagsService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 种子标签Controller
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@RestController
@RequestMapping("/system/tags")
public class BtTorrentTagsController extends BaseController
{
    @Autowired
    private IBtTorrentTagsService btTorrentTagsService;

    /**
     * 查询种子标签列表
     */
    @PreAuthorize("@ss.hasPermi('system:tags:list')")
    @GetMapping("/list")
    public TableDataInfo list(BtTorrentTags btTorrentTags)
    {
        startPage();
        List<BtTorrentTags> list = btTorrentTagsService.selectBtTorrentTagsList(btTorrentTags);
        return getDataTable(list);
    }

    /**
     * 导出种子标签列表
     */
    @PreAuthorize("@ss.hasPermi('system:tags:export')")
    @Log(title = "种子标签", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BtTorrentTags btTorrentTags)
    {
        List<BtTorrentTags> list = btTorrentTagsService.selectBtTorrentTagsList(btTorrentTags);
        ExcelUtil<BtTorrentTags> util = new ExcelUtil<BtTorrentTags>(BtTorrentTags.class);
        util.exportExcel(response, list, "种子标签数据");
    }

    /**
     * 获取种子标签详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:tags:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(btTorrentTagsService.selectBtTorrentTagsById(id));
    }

    /**
     * 新增种子标签
     */
    @PreAuthorize("@ss.hasPermi('system:tags:add')")
    @Log(title = "种子标签", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BtTorrentTags btTorrentTags)
    {
        return toAjax(btTorrentTagsService.insertBtTorrentTags(btTorrentTags));
    }

    /**
     * 修改种子标签
     */
    @PreAuthorize("@ss.hasPermi('system:tags:edit')")
    @Log(title = "种子标签", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BtTorrentTags btTorrentTags)
    {
        return toAjax(btTorrentTagsService.updateBtTorrentTags(btTorrentTags));
    }

    /**
     * 删除种子标签
     */
    @PreAuthorize("@ss.hasPermi('system:tags:remove')")
    @Log(title = "种子标签", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(btTorrentTagsService.deleteBtTorrentTagsByIds(ids));
    }
}
