package com.ruoyi.torrent.mapper;

import java.util.List;
import com.ruoyi.torrent.domain.BtTorrentTags;

/**
 * 种子标签Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
public interface BtTorrentTagsMapper 
{
    /**
     * 查询种子标签
     * 
     * @param id 种子标签主键
     * @return 种子标签
     */
    public BtTorrentTags selectBtTorrentTagsById(Long id);

    /**
     * 查询种子标签列表
     * 
     * @param btTorrentTags 种子标签
     * @return 种子标签集合
     */
    public List<BtTorrentTags> selectBtTorrentTagsList(BtTorrentTags btTorrentTags);

    /**
     * 新增种子标签
     * 
     * @param btTorrentTags 种子标签
     * @return 结果
     */
    public int insertBtTorrentTags(BtTorrentTags btTorrentTags);

    /**
     * 修改种子标签
     * 
     * @param btTorrentTags 种子标签
     * @return 结果
     */
    public int updateBtTorrentTags(BtTorrentTags btTorrentTags);

    /**
     * 删除种子标签
     * 
     * @param id 种子标签主键
     * @return 结果
     */
    public int deleteBtTorrentTagsById(Long id);

    /**
     * 批量删除种子标签
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBtTorrentTagsByIds(Long[] ids);
}
