package com.ruoyi.torrent.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.torrent.mapper.BtTorrentFileMapper;
import com.ruoyi.torrent.domain.BtTorrentFile;
import com.ruoyi.torrent.service.IBtTorrentFileService;

/**
 * 种子包含的文件列Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@Service
public class BtTorrentFileServiceImpl implements IBtTorrentFileService 
{
    @Autowired
    private BtTorrentFileMapper btTorrentFileMapper;

    /**
     * 查询种子包含的文件列
     * 
     * @param id 种子包含的文件列主键
     * @return 种子包含的文件列
     */
    @Override
    public BtTorrentFile selectBtTorrentFileById(Long id)
    {
        return btTorrentFileMapper.selectBtTorrentFileById(id);
    }

    /**
     * 查询种子包含的文件列列表
     * 
     * @param btTorrentFile 种子包含的文件列
     * @return 种子包含的文件列
     */
    @Override
    public List<BtTorrentFile> selectBtTorrentFileList(BtTorrentFile btTorrentFile)
    {
        return btTorrentFileMapper.selectBtTorrentFileList(btTorrentFile);
    }

    /**
     * 新增种子包含的文件列
     * 
     * @param btTorrentFile 种子包含的文件列
     * @return 结果
     */
    @Override
    public int insertBtTorrentFile(BtTorrentFile btTorrentFile)
    {
        return btTorrentFileMapper.insertBtTorrentFile(btTorrentFile);
    }

    /**
     * 修改种子包含的文件列
     * 
     * @param btTorrentFile 种子包含的文件列
     * @return 结果
     */
    @Override
    public int updateBtTorrentFile(BtTorrentFile btTorrentFile)
    {
        return btTorrentFileMapper.updateBtTorrentFile(btTorrentFile);
    }

    /**
     * 批量删除种子包含的文件列
     * 
     * @param ids 需要删除的种子包含的文件列主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentFileByIds(Long[] ids)
    {
        return btTorrentFileMapper.deleteBtTorrentFileByIds(ids);
    }

    /**
     * 删除种子包含的文件列信息
     * 
     * @param id 种子包含的文件列主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentFileById(Long id)
    {
        return btTorrentFileMapper.deleteBtTorrentFileById(id);
    }
}
