package com.ruoyi.tracker.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.tracker.mapper.TrackerTaskMapper;
import com.ruoyi.tracker.domain.TrackerTask;
import com.ruoyi.tracker.service.ITrackerTaskService;

/**
 * 任务Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
@Service
public class TrackerTaskServiceImpl implements ITrackerTaskService 
{
    @Autowired
    private TrackerTaskMapper trackerTaskMapper;

    /**
     * 查询任务
     * 
     * @param taskId 任务主键
     * @return 任务
     */
    @Override
    public TrackerTask selectTrackerTaskByTaskId(Long taskId)
    {
        return trackerTaskMapper.selectTrackerTaskByTaskId(taskId);
    }

    /**
     * 查询任务列表
     * 
     * @param trackerTask 任务
     * @return 任务
     */
    @Override
    public List<TrackerTask> selectTrackerTaskList(TrackerTask trackerTask)
    {
        return trackerTaskMapper.selectTrackerTaskList(trackerTask);
    }

    /**
     * 新增任务
     * 
     * @param trackerTask 任务
     * @return 结果
     */
    @Override
    public int insertTrackerTask(TrackerTask trackerTask)
    {
        trackerTask.setCreateTime(DateUtils.getNowDate());
        return trackerTaskMapper.insertTrackerTask(trackerTask);
    }

    /**
     * 修改任务
     * 
     * @param trackerTask 任务
     * @return 结果
     */
    @Override
    public int updateTrackerTask(TrackerTask trackerTask)
    {
        trackerTask.setUpdateTime(DateUtils.getNowDate());
        return trackerTaskMapper.updateTrackerTask(trackerTask);
    }

    /**
     * 批量删除任务
     * 
     * @param taskIds 需要删除的任务主键
     * @return 结果
     */
    @Override
    public int deleteTrackerTaskByTaskIds(Long[] taskIds)
    {
        return trackerTaskMapper.deleteTrackerTaskByTaskIds(taskIds);
    }

    /**
     * 删除任务信息
     * 
     * @param taskId 任务主键
     * @return 结果
     */
    @Override
    public int deleteTrackerTaskByTaskId(Long taskId)
    {
        return trackerTaskMapper.deleteTrackerTaskByTaskId(taskId);
    }
}
