package com.ruoyi.reward.controller;

import java.util.List;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.reward.domain.RewardTasks;
import com.ruoyi.reward.service.IRewardTasksService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 * 
 * @author ruoyi
 * @date 2025-05-17
 */
@RestController
@RequestMapping("/reward")
public class RewardTasksController extends BaseController
{
    @Autowired
    private IRewardTasksService rewardTasksService;

    /**
     * 查询【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('system:tasks:list')")
    @GetMapping("/list")
    public TableDataInfo list(RewardTasks rewardTasks)
    {
        startPage();
        List<RewardTasks> list = rewardTasksService.selectRewardTasksList(rewardTasks);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('system:tasks:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RewardTasks rewardTasks)
    {
        List<RewardTasks> list = rewardTasksService.selectRewardTasksList(rewardTasks);
        ExcelUtil<RewardTasks> util = new ExcelUtil<RewardTasks>(RewardTasks.class);
        util.exportExcel(response, list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:tasks:query')")
    @GetMapping(value = "/{rewardId}")
    public AjaxResult getInfo(@PathVariable("rewardId") Long rewardId)
    {
        return success(rewardTasksService.selectRewardTasksByRewardId(rewardId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('system:tasks:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RewardTasks rewardTasks)
    {
        return toAjax(rewardTasksService.insertRewardTasks(rewardTasks));
    }

    /**
     * 修改【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('system:tasks:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RewardTasks rewardTasks)
    {
        return toAjax(rewardTasksService.updateRewardTasks(rewardTasks));
    }

    /**
     * 删除【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('system:tasks:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{rewardIds}")
    public AjaxResult remove(@PathVariable Long[] rewardIds)
    {
        return toAjax(rewardTasksService.deleteRewardTasksByRewardIds(rewardIds));
    }
}
