package com.ruoyi.torrent.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 种子主对象 bt_torrent
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class BtTorrent extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 种子ID */
    private Long torrentId;

    /** InfoHash */
    @Excel(name = "InfoHash")
    private String infoHash;

    /** 种子名称 */
    @Excel(name = "种子名称")
    private String name;

    /** 总大小（字节） */
    @Excel(name = "总大小", readConverterExp = "字=节")
    private Long length;

    /** 每个 piece 的长度 */
    @Excel(name = "每个 piece 的长度")
    private Long pieceLength;

    /** piece 总数 */
    @Excel(name = "piece 总数")
    private Long piecesCount;

    /** 创建工具 */
    @Excel(name = "创建工具")
    private String createdBy;

    /** 种子内记录的创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "种子内记录的创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date torrentCreateTime;

    /** 上传用户ID（关联 sys_user.user_id） */
    @Excel(name = "上传用户ID", readConverterExp = "关=联,s=ys_user.user_id")
    private Long uploaderId;

    /** 上传时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上传时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date uploadTime;

    /** 种子文件在服务器的存储路径 */
    @Excel(name = "种子文件在服务器的存储路径")
    private String filePath;

    public void setTorrentId(Long torrentId) 
    {
        this.torrentId = torrentId;
    }

    public Long getTorrentId() 
    {
        return torrentId;
    }
    public void setInfoHash(String infoHash) 
    {
        this.infoHash = infoHash;
    }

    public String getInfoHash() 
    {
        return infoHash;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setLength(Long length) 
    {
        this.length = length;
    }

    public Long getLength() 
    {
        return length;
    }
    public void setPieceLength(Long pieceLength) 
    {
        this.pieceLength = pieceLength;
    }

    public Long getPieceLength() 
    {
        return pieceLength;
    }
    public void setPiecesCount(Long piecesCount) 
    {
        this.piecesCount = piecesCount;
    }

    public Long getPiecesCount() 
    {
        return piecesCount;
    }
    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }
    public void setTorrentCreateTime(Date torrentCreateTime) 
    {
        this.torrentCreateTime = torrentCreateTime;
    }

    public Date getTorrentCreateTime() 
    {
        return torrentCreateTime;
    }
    public void setUploaderId(Long uploaderId) 
    {
        this.uploaderId = uploaderId;
    }

    public Long getUploaderId() 
    {
        return uploaderId;
    }
    public void setUploadTime(Date uploadTime) 
    {
        this.uploadTime = uploadTime;
    }

    public Date getUploadTime() 
    {
        return uploadTime;
    }
    public void setFilePath(String filePath) 
    {
        this.filePath = filePath;
    }

    public String getFilePath() 
    {
        return filePath;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("torrentId", getTorrentId())
            .append("infoHash", getInfoHash())
            .append("name", getName())
            .append("length", getLength())
            .append("pieceLength", getPieceLength())
            .append("piecesCount", getPiecesCount())
            .append("createdBy", getCreatedBy())
            .append("torrentCreateTime", getTorrentCreateTime())
            .append("uploaderId", getUploaderId())
            .append("uploadTime", getUploadTime())
            .append("filePath", getFilePath())
            .toString();
    }
}
