package com.ruoyi.reward.mapper;

import java.util.List;
import com.ruoyi.reward.domain.RewardTasks;
import org.apache.ibatis.annotations.Mapper;

/**
 * 悬赏任务Mapper接口
 *
 * @author ruoyi
 * @date 2025-05-17
 */
@Mapper
public interface RewardTasksMapper
{
    /**
     * 查询悬赏任务
     *
     * @param rewardId 悬赏任务主键
     * @return 悬赏任务
     */
    public RewardTasks selectRewardTasksByRewardId(Long rewardId);

    /**
     * 查询悬赏任务列表
     *
     * @param rewardTasks 悬赏任务
     * @return 悬赏任务集合
     */
    public List<RewardTasks> selectRewardTasksList(RewardTasks rewardTasks);

    /**
     * 新增悬赏任务
     *
     * @param rewardTasks 悬赏任务
     * @return 结果
     */
    public int insertRewardTasks(RewardTasks rewardTasks);

    /**
     * 修改悬赏任务
     *
     * @param rewardTasks 悬赏任务
     * @return 结果
     */
    public int updateRewardTasks(RewardTasks rewardTasks);

    /**
     * 删除悬赏任务
     *
     * @param rewardId 悬赏任务主键
     * @return 结果
     */
    public int deleteRewardTasksByRewardId(Long rewardId);

    /**
     * 批量删除悬赏任务
     *
     * @param rewardIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRewardTasksByRewardIds(Long[] rewardIds);

    /**
     * 根据悬赏ID查询悬赏BT
     *
     * @param rewardId 悬赏任务ID
     * @return 悬赏BT的torrent_id
     */
    public Integer selectRewardBtByRewardId(Integer rewardId);

    /**
     * 新增悬赏BT
     *
     * @param rewardId 悬赏任务ID
     * @param rewardBt Torrent ID
     * @return 结果
     */
    public int insertRewardBt(Integer rewardId, Integer rewardBt);
}