package com.ruoyi.torrent.mapper;

import java.util.List;
import com.ruoyi.torrent.domain.BtTorrentAnnounce;

/**
 * 种子的 Tracker 列Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
public interface BtTorrentAnnounceMapper 
{
    /**
     * 查询种子的 Tracker 列
     * 
     * @param id 种子的 Tracker 列主键
     * @return 种子的 Tracker 列
     */
    public BtTorrentAnnounce selectBtTorrentAnnounceById(Long id);

    /**
     * 查询种子的 Tracker 列列表
     * 
     * @param btTorrentAnnounce 种子的 Tracker 列
     * @return 种子的 Tracker 列集合
     */
    public List<BtTorrentAnnounce> selectBtTorrentAnnounceList(BtTorrentAnnounce btTorrentAnnounce);

    /**
     * 新增种子的 Tracker 列
     * 
     * @param btTorrentAnnounce 种子的 Tracker 列
     * @return 结果
     */
    public int insertBtTorrentAnnounce(BtTorrentAnnounce btTorrentAnnounce);

    /**
     * 修改种子的 Tracker 列
     * 
     * @param btTorrentAnnounce 种子的 Tracker 列
     * @return 结果
     */
    public int updateBtTorrentAnnounce(BtTorrentAnnounce btTorrentAnnounce);

    /**
     * 删除种子的 Tracker 列
     * 
     * @param id 种子的 Tracker 列主键
     * @return 结果
     */
    public int deleteBtTorrentAnnounceById(Long id);

    /**
     * 批量删除种子的 Tracker 列
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBtTorrentAnnounceByIds(Long[] ids);
}
