package com.ruoyi.torrent.service;

import java.util.List;
import com.ruoyi.torrent.domain.BtTorrent;

/**
 * 种子主Service接口
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
public interface IBtTorrentService 
{
    /**
     * 查询种子主
     * 
     * @param torrentId 种子主主键
     * @return 种子主
     */
    public BtTorrent selectBtTorrentByTorrentId(Long torrentId);

    /**
     * 查询种子主列表
     * 
     * @param btTorrent 种子主
     * @return 种子主集合
     */
    public List<BtTorrent> selectBtTorrentList(BtTorrent btTorrent);

    /**
     * 新增种子主
     * 
     * @param btTorrent 种子主
     * @return 结果
     */
    public int insertBtTorrent(BtTorrent btTorrent);

    /**
     * 修改种子主
     * 
     * @param btTorrent 种子主
     * @return 结果
     */
    public int updateBtTorrent(BtTorrent btTorrent);

    /**
     * 批量删除种子主
     * 
     * @param torrentIds 需要删除的种子主主键集合
     * @return 结果
     */
    public int deleteBtTorrentByTorrentIds(Long[] torrentIds);

    /**
     * 删除种子主信息
     * 
     * @param torrentId 种子主主键
     * @return 结果
     */
    public int deleteBtTorrentByTorrentId(Long torrentId);

    /**
     * 根据推荐ID列表查询种子信息（保持推荐顺序）
     *
     * @param ids 推荐的种子ID列表
     * @return 按照推荐顺序排列的种子列表
     */
    List<BtTorrent> selectBtTorrentsByIdsOrdered(List<Long> ids);
}
