package com.ruoyi.tracker.mapper;

import java.util.List;
import com.ruoyi.tracker.domain.TrackerProjectUser;

/**
 * 项目与用户关联Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
public interface TrackerProjectUserMapper 
{
    /**
     * 查询项目与用户关联
     * 
     * @param projectId 项目与用户关联主键
     * @return 项目与用户关联
     */
    public TrackerProjectUser selectTrackerProjectUserByProjectId(Long projectId);

    /**
     * 查询项目与用户关联列表
     * 
     * @param trackerProjectUser 项目与用户关联
     * @return 项目与用户关联集合
     */
    public List<TrackerProjectUser> selectTrackerProjectUserList(TrackerProjectUser trackerProjectUser);

    /**
     * 新增项目与用户关联
     * 
     * @param trackerProjectUser 项目与用户关联
     * @return 结果
     */
    public int insertTrackerProjectUser(TrackerProjectUser trackerProjectUser);

    /**
     * 修改项目与用户关联
     * 
     * @param trackerProjectUser 项目与用户关联
     * @return 结果
     */
    public int updateTrackerProjectUser(TrackerProjectUser trackerProjectUser);

    /**
     * 删除项目与用户关联
     * 
     * @param projectId 项目与用户关联主键
     * @return 结果
     */
    public int deleteTrackerProjectUserByProjectId(Long projectId);

    /**
     * 批量删除项目与用户关联
     * 
     * @param projectIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTrackerProjectUserByProjectIds(Long[] projectIds);
}
