package com.ruoyi.tracker.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.tracker.mapper.TrackerTaskLogMapper;
import com.ruoyi.tracker.domain.TrackerTaskLog;
import com.ruoyi.tracker.service.ITrackerTaskLogService;

/**
 * 任务日志Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
@Service
public class TrackerTaskLogServiceImpl implements ITrackerTaskLogService 
{
    @Autowired
    private TrackerTaskLogMapper trackerTaskLogMapper;

    /**
     * 查询任务日志
     * 
     * @param logId 任务日志主键
     * @return 任务日志
     */
    @Override
    public TrackerTaskLog selectTrackerTaskLogByLogId(Long logId)
    {
        return trackerTaskLogMapper.selectTrackerTaskLogByLogId(logId);
    }

    /**
     * 查询任务日志列表
     * 
     * @param trackerTaskLog 任务日志
     * @return 任务日志
     */
    @Override
    public List<TrackerTaskLog> selectTrackerTaskLogList(TrackerTaskLog trackerTaskLog)
    {
        return trackerTaskLogMapper.selectTrackerTaskLogList(trackerTaskLog);
    }

    /**
     * 新增任务日志
     * 
     * @param trackerTaskLog 任务日志
     * @return 结果
     */
    @Override
    public int insertTrackerTaskLog(TrackerTaskLog trackerTaskLog)
    {
        trackerTaskLog.setCreateTime(DateUtils.getNowDate());
        return trackerTaskLogMapper.insertTrackerTaskLog(trackerTaskLog);
    }

    /**
     * 修改任务日志
     * 
     * @param trackerTaskLog 任务日志
     * @return 结果
     */
    @Override
    public int updateTrackerTaskLog(TrackerTaskLog trackerTaskLog)
    {
        return trackerTaskLogMapper.updateTrackerTaskLog(trackerTaskLog);
    }

    /**
     * 批量删除任务日志
     * 
     * @param logIds 需要删除的任务日志主键
     * @return 结果
     */
    @Override
    public int deleteTrackerTaskLogByLogIds(Long[] logIds)
    {
        return trackerTaskLogMapper.deleteTrackerTaskLogByLogIds(logIds);
    }

    /**
     * 删除任务日志信息
     * 
     * @param logId 任务日志主键
     * @return 结果
     */
    @Override
    public int deleteTrackerTaskLogByLogId(Long logId)
    {
        return trackerTaskLogMapper.deleteTrackerTaskLogByLogId(logId);
    }
}
