// 种子评论服务实现 (SysTorrentCommentServiceImpl.java)
package com.ruoyi.system.service.impl;

import com.ruoyi.system.domain.SysTorrentComment;
import com.ruoyi.system.mapper.SysTorrentCommentMapper;
import com.ruoyi.system.service.ISysTorrentCommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class SysTorrentCommentServiceImpl implements ISysTorrentCommentService {
    @Autowired
    private SysTorrentCommentMapper commentMapper;

    @Override
    public int addComment(SysTorrentComment comment) {
        return commentMapper.insertComment(comment);
    }

    @Override
    public List<SysTorrentComment> getCommentList(Long torrentId) {
        return commentMapper.selectCommentListByTorrentId(torrentId);
    }

    @Override
    public int deleteComment(Long commentId) {
        return commentMapper.deleteCommentById(commentId);
    }
}