package com.ruoyi.torrent.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.torrent.mapper.BtTorrentAnnounceMapper;
import com.ruoyi.torrent.domain.BtTorrentAnnounce;
import com.ruoyi.torrent.service.IBtTorrentAnnounceService;

/**
 * 种子的 Tracker 列Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@Service
public class BtTorrentAnnounceServiceImpl implements IBtTorrentAnnounceService 
{
    @Autowired
    private BtTorrentAnnounceMapper btTorrentAnnounceMapper;

    /**
     * 查询种子的 Tracker 列
     * 
     * @param id 种子的 Tracker 列主键
     * @return 种子的 Tracker 列
     */
    @Override
    public BtTorrentAnnounce selectBtTorrentAnnounceById(Long id)
    {
        return btTorrentAnnounceMapper.selectBtTorrentAnnounceById(id);
    }

    /**
     * 查询种子的 Tracker 列列表
     * 
     * @param btTorrentAnnounce 种子的 Tracker 列
     * @return 种子的 Tracker 列
     */
    @Override
    public List<BtTorrentAnnounce> selectBtTorrentAnnounceList(BtTorrentAnnounce btTorrentAnnounce)
    {
        return btTorrentAnnounceMapper.selectBtTorrentAnnounceList(btTorrentAnnounce);
    }

    /**
     * 新增种子的 Tracker 列
     * 
     * @param btTorrentAnnounce 种子的 Tracker 列
     * @return 结果
     */
    @Override
    public int insertBtTorrentAnnounce(BtTorrentAnnounce btTorrentAnnounce)
    {
        return btTorrentAnnounceMapper.insertBtTorrentAnnounce(btTorrentAnnounce);
    }

    /**
     * 修改种子的 Tracker 列
     * 
     * @param btTorrentAnnounce 种子的 Tracker 列
     * @return 结果
     */
    @Override
    public int updateBtTorrentAnnounce(BtTorrentAnnounce btTorrentAnnounce)
    {
        return btTorrentAnnounceMapper.updateBtTorrentAnnounce(btTorrentAnnounce);
    }

    /**
     * 批量删除种子的 Tracker 列
     * 
     * @param ids 需要删除的种子的 Tracker 列主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentAnnounceByIds(Long[] ids)
    {
        return btTorrentAnnounceMapper.deleteBtTorrentAnnounceByIds(ids);
    }

    /**
     * 删除种子的 Tracker 列信息
     * 
     * @param id 种子的 Tracker 列主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentAnnounceById(Long id)
    {
        return btTorrentAnnounceMapper.deleteBtTorrentAnnounceById(id);
    }
}
