package com.ruoyi.tracker.service;

import java.util.List;
import com.ruoyi.tracker.domain.TrackerProject;

/**
 * 项目Service接口
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
public interface ITrackerProjectService 
{
    /**
     * 查询项目
     * 
     * @param projectId 项目主键
     * @return 项目
     */
    public TrackerProject selectTrackerProjectByProjectId(Long projectId);

    /**
     * 查询项目列表
     * 
     * @param trackerProject 项目
     * @return 项目集合
     */
    public List<TrackerProject> selectTrackerProjectList(TrackerProject trackerProject);

    /**
     * 新增项目
     * 
     * @param trackerProject 项目
     * @return 结果
     */
    public int insertTrackerProject(TrackerProject trackerProject);

    /**
     * 修改项目
     * 
     * @param trackerProject 项目
     * @return 结果
     */
    public int updateTrackerProject(TrackerProject trackerProject);

    /**
     * 批量删除项目
     * 
     * @param projectIds 需要删除的项目主键集合
     * @return 结果
     */
    public int deleteTrackerProjectByProjectIds(Long[] projectIds);

    /**
     * 删除项目信息
     * 
     * @param projectId 项目主键
     * @return 结果
     */
    public int deleteTrackerProjectByProjectId(Long projectId);
}
