package com.ruoyi.tracker.service;

import java.util.List;
import com.ruoyi.tracker.domain.TrackerTaskLog;

/**
 * 任务日志Service接口
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
public interface ITrackerTaskLogService 
{
    /**
     * 查询任务日志
     * 
     * @param logId 任务日志主键
     * @return 任务日志
     */
    public TrackerTaskLog selectTrackerTaskLogByLogId(Long logId);

    /**
     * 查询任务日志列表
     * 
     * @param trackerTaskLog 任务日志
     * @return 任务日志集合
     */
    public List<TrackerTaskLog> selectTrackerTaskLogList(TrackerTaskLog trackerTaskLog);

    /**
     * 新增任务日志
     * 
     * @param trackerTaskLog 任务日志
     * @return 结果
     */
    public int insertTrackerTaskLog(TrackerTaskLog trackerTaskLog);

    /**
     * 修改任务日志
     * 
     * @param trackerTaskLog 任务日志
     * @return 结果
     */
    public int updateTrackerTaskLog(TrackerTaskLog trackerTaskLog);

    /**
     * 批量删除任务日志
     * 
     * @param logIds 需要删除的任务日志主键集合
     * @return 结果
     */
    public int deleteTrackerTaskLogByLogIds(Long[] logIds);

    /**
     * 删除任务日志信息
     * 
     * @param logId 任务日志主键
     * @return 结果
     */
    public int deleteTrackerTaskLogByLogId(Long logId);
}
