// 消息接口
export interface SysUserMessage {
    messageId: number;
    senderId: number;
    receiverId: number;
    content: string;
    createTime: Date;
    delFlag: string;
}

// 聊天对象接口
export interface ChatContact {
    userId: number;
    nickName: string;
    avatar?: string;
    lastMessage: string;
    lastMessageTime: Date;
}

// 获取聊天对象列表参数
export interface ChatContactListParams {
    pageNum?: number;
    pageSize?: number;
    keyword?: string; // 搜索关键词
}

// 获取聊天记录参数
export interface ChatHistoryParams {
    userId: number; // 聊天对象用户ID
    currentUserId?: number; // 当前用户ID
    pageNum?: number;
    pageSize?: number;
}

// 发送消息参数
export interface SendMessageParams {
    receiverId: number;
    content: string;
}

// 用户信息接口
export interface UserInfo {
    userId: number;
    nickName: string;
    avatar?: string;
}

// API 响应基础接口
export interface ApiResponse<T = any> {
    code: number;
    message: string;
    data: T;
    success: boolean;
}

// 分页响应接口
export interface PageResponse<T = any> {
    list: T[];
    total: number;
    pageNum: number;
    pageSize: number;
    pages: number;
}