export interface RewardItem {
    /** 悬赏ID */
    rewardId?: number;
    /** 悬赏标题 */
    title: string;
    /** 悬赏描述 */
    description: string;
    /** 悬赏金额 */
    amount: number;
    /** 悬赏状态（0进行中 1已完成 2已取消） */
    status?: string;
    /** 发布者ID */
    publisherId?: number;
    /** 接受者ID */
    accepterId?: number;
    /** 创建时间 */
    createTime?: string;
    /** 更新时间 */
    updateTime?: string;
    /** 备注 */
    remark?: string;
}

export interface RewardListParams {
    /** 当前的页码 */
    pageNum?: number;
    /** 页面的容量 */
    pageSize?: number;
    /** 悬赏标题 */
    title?: string;
    /** 悬赏状态 */
    status?: string;
    /** 开始时间 */
    'params[beginTime]'?: string;
    /** 结束时间 */
    'params[endTime]'?: string;
}

