// data.d.ts

/** 项目表 */
export interface TrackerProject {
  /** 项目ID */
  projectId: number;
  /** 项目名称 */
  projectName: string;
  /** 项目描述 */
  description: string;
  /** 项目状态（active: 激活, inactive: 不活跃） */
  status: 'active' | 'inactive';
  /** 创建者 */
  createBy: string;
  /** 创建时间 */
  createTime: Date | null;
  /** 更新者 */
  updateBy: string;
  /** 更新时间 */
  updateTime: Date | null;
}

/** 项目与用户关联表 */
export interface TrackerProjectUser {
  /** 项目ID */
  projectId: number;
  /** 用户ID */
  userId: number;
  /** 角色（管理员、成员等） */
  role: string;
  /** 加入时间 */
  createTime: Date;
}

/** 任务表 */
export interface TrackerTask {
  /** 任务ID */
  taskId: number;
  /** 所属项目ID */
  projectId: number;
  /** 任务名称 */
  taskName: string;
  /** 任务描述 */
  description: string;
  /** 分配给的用户ID */
  assignedTo: number;
  /** 任务状态（open: 待办, in_progress: 进行中, closed: 完成） */
  status: 'open' | 'in_progress' | 'closed';
  /** 任务优先级（low, medium, high） */
  priority: 'low' | 'medium' | 'high';
  /** 创建时间 */
  createTime: Date | null;
  /** 更新时间 */
  updateTime: Date | null;
}

/** 任务日志表 */
export interface TrackerTaskLog {
  /** 日志ID */
  logId: number;
  /** 任务ID */
  taskId: number;
  /** 操作用户ID */
  userId: number;
  /** 操作类型（创建、更新、删除） */
  action: '创建' | '更新' | '删除';
  /** 操作描述 */
  description: string;
  /** 创建时间 */
  createTime: Date | null;
}
