import os
import urllib.request
from recommend import train_and_save_itemcf
MODEL_URL = "https://dl.fbaipublicfiles.com/fasttext/vectors-crawl/cc.zh.300.bin.gz"
MODEL_DIR = "./models"
MODEL_PATH = os.path.join(MODEL_DIR, "cc.zh.300.bin")
COMPRESSED_PATH = MODEL_PATH + ".gz"

def download_model():
    if not os.path.exists(MODEL_DIR):
        os.makedirs(MODEL_DIR)

    if os.path.exists(MODEL_PATH):
        print("✅ 模型已存在，跳过下载。")
        return

    print("⏬ 下载 fastText 中文模型...")
    urllib.request.urlretrieve(MODEL_URL, COMPRESSED_PATH)

    print("📦 解压模型文件...")
    import gzip
    import shutil
    with gzip.open(COMPRESSED_PATH, 'rb') as f_in:
        with open(MODEL_PATH, 'wb') as f_out:
            shutil.copyfileobj(f_in, f_out)

    os.remove(COMPRESSED_PATH)
    print("✅ 模型下载并解压完成！")

if __name__ == "__main__":
    train_and_save_itemcf()
    download_model()
