package com.ruoyi.torrent.controller;

import java.util.List;

import com.ruoyi.torrent.service.IBtTorrentAnnounceService;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.torrent.domain.BtTorrentAnnounce;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 种子的 Tracker 列Controller
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@RestController
@RequestMapping("/system/announce")
public class BtTorrentAnnounceController extends BaseController
{
    @Autowired
    private IBtTorrentAnnounceService btTorrentAnnounceService;

    /**
     * 查询种子的 Tracker 列列表
     */
    @PreAuthorize("@ss.hasPermi('system:announce:list')")
    @GetMapping("/list")
    public TableDataInfo list(BtTorrentAnnounce btTorrentAnnounce)
    {
        startPage();
        List<BtTorrentAnnounce> list = btTorrentAnnounceService.selectBtTorrentAnnounceList(btTorrentAnnounce);
        return getDataTable(list);
    }

    /**
     * 导出种子的 Tracker 列列表
     */
    @PreAuthorize("@ss.hasPermi('system:announce:export')")
    @Log(title = "种子的 Tracker 列", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BtTorrentAnnounce btTorrentAnnounce)
    {
        List<BtTorrentAnnounce> list = btTorrentAnnounceService.selectBtTorrentAnnounceList(btTorrentAnnounce);
        ExcelUtil<BtTorrentAnnounce> util = new ExcelUtil<BtTorrentAnnounce>(BtTorrentAnnounce.class);
        util.exportExcel(response, list, "种子的 Tracker 列数据");
    }

    /**
     * 获取种子的 Tracker 列详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:announce:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(btTorrentAnnounceService.selectBtTorrentAnnounceById(id));
    }

    /**
     * 新增种子的 Tracker 列
     */
    @PreAuthorize("@ss.hasPermi('system:announce:add')")
    @Log(title = "种子的 Tracker 列", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BtTorrentAnnounce btTorrentAnnounce)
    {
        return toAjax(btTorrentAnnounceService.insertBtTorrentAnnounce(btTorrentAnnounce));
    }

    /**
     * 修改种子的 Tracker 列
     */
    @PreAuthorize("@ss.hasPermi('system:announce:edit')")
    @Log(title = "种子的 Tracker 列", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BtTorrentAnnounce btTorrentAnnounce)
    {
        return toAjax(btTorrentAnnounceService.updateBtTorrentAnnounce(btTorrentAnnounce));
    }

    /**
     * 删除种子的 Tracker 列
     */
    @PreAuthorize("@ss.hasPermi('system:announce:remove')")
    @Log(title = "种子的 Tracker 列", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(btTorrentAnnounceService.deleteBtTorrentAnnounceByIds(ids));
    }
}
