package com.ruoyi.web.controller.system;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.SysUserMessage;
import com.ruoyi.system.service.ISysUserMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/system/user/message")
public class SysUserMessageController extends BaseController {
    @Autowired
    private ISysUserMessageService messageService;

    @PreAuthorize("@ss.hasPermi('system:user:message:add')")
    @PostMapping
    public AjaxResult sendMessage(@RequestBody SysUserMessage message) {
        message.setSenderId(getUserId());
        return toAjax(messageService.sendMessage(message));
    }

    @GetMapping("/list")
    public AjaxResult list(@RequestParam Long userId1, @RequestParam Long userId2) {
        System.out.println(AjaxResult.success(messageService.getMessageList(userId1, userId2)));
        return AjaxResult.success(messageService.getMessageList(userId1, userId2));
    }

    // 新增获取与当前用户聊过天的用户ID和昵称的接口
    @GetMapping("/chat/users")
    public AjaxResult getChatUsers() {
        Long currentUserId = getUserId();
        return AjaxResult.success(messageService.getChatUsers(currentUserId));
    }
}