package com.ruoyi.system.service.impl;

import com.ruoyi.system.domain.SysUserMessage;
import com.ruoyi.system.mapper.SysUserMessageMapper;
import com.ruoyi.system.mapper.SysUserMapper;
import com.ruoyi.system.service.ISysUserMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class SysUserMessageServiceImpl implements ISysUserMessageService {
    @Autowired
    private SysUserMessageMapper messageMapper;
    @Autowired
    private SysUserMapper userMapper; // 新增：用于查询用户昵称

    @Override
    public int sendMessage(SysUserMessage message) {
        return messageMapper.insertMessage(message);
    }

    @Override
    public List<SysUserMessage> getMessageList(Long userId1, Long userId2) {
        return messageMapper.selectMessageListByUserIds(userId1, userId2);
    }


    @Override
    public List<Map<String, Object>> getChatUsers(Long userId) {
        List<Map<String, Object>> chatUsers = messageMapper.selectChatUserIds(userId);
        return chatUsers != null ? chatUsers : new ArrayList<>();
    }
}