package com.ruoyi.system.service.impl;

import com.ruoyi.system.domain.SysUserFollow;
import com.ruoyi.system.domain.SysUserMessage;
import com.ruoyi.system.mapper.SysUserFollowMapper;
import com.ruoyi.system.service.ISysUserFollowService;
import com.ruoyi.system.service.ISysUserMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class SysUserFollowServiceImpl implements ISysUserFollowService {
    @Autowired
    private SysUserFollowMapper followMapper;

    @Autowired
    private ISysUserMessageService messageService;

    @Override
    public int followAuthor(SysUserFollow follow) {
        // 根据 authorUsername 查询 authorId
        Long authorId = followMapper.selectUserIdByUsername(follow.getAuthorUsername());
        if (authorId == null) {
            return -1; // 作者不存在
        }
        follow.setAuthorId(authorId);

        // 检查是否已关注
        if (followMapper.selectFollow(follow) != null) {
            return 0; // 已经关注
        }

        // 插入关注记录
        int result = followMapper.insertFollow(follow);
        if (result > 0) {
            // 发送 "hello" 消息
            SysUserMessage message = new SysUserMessage();
            message.setSenderId(follow.getUserId());
            message.setReceiverId(authorId);
            message.setContent("hello");
            messageService.sendMessage(message);
        }
        return result;
    }

    @Override
    public int unfollowAuthor(SysUserFollow follow) {
        // 根据 authorUsername 查询 authorId
        Long authorId = followMapper.selectUserIdByUsername(follow.getAuthorUsername());
        if (authorId == null) {
            return -1; // 作者不存在
        }
        follow.setAuthorId(authorId);

        return followMapper.deleteFollow(follow); // 返回删除的行数（0 或 1）
    }

    @Override
    public List<SysUserFollow> getFollowList(Long userId) {
        return followMapper.selectFollowListByUserId(userId);
    }

    @Override
    public boolean isFollowing(SysUserFollow follow) {
        // 根据 authorUsername 查询 authorId
        Long authorId = followMapper.selectUserIdByUsername(follow.getAuthorUsername());
        if (authorId == null) {
            return false; // 作者不存在
        }
        follow.setAuthorId(authorId);

        return followMapper.selectFollow(follow) != null;
    }
}