package com.ruoyi.announce.service;

import java.io.IOException;
import java.util.Map;

/**
 * BT Tracker announce 服务接口
 */
public interface IAnnounceService {

    /**
     * 处理一次 announce 请求：
     * - 校验 passkey
     * - 记录/刷新 peer 信息到 Redis
     * - 从 Redis 随机挑选 peers
     * - 构造待 bencode 的响应 Map
     *
     * @param infoHash  原始 20 字节 info_hash
     * @param peerId    原始 20 字节 peer_id
     * @param port      客户端监听端口
     * @param uploaded  已上传字节数
     * @param downloaded 已下载字节数
     * @param left      剩余下载字节数
     * @param event     事件（started/completed/stopped）
     * @param passkey   用户的 passkey
     * @param ip        客户端 IP
     * @return 一个可以直接 bencode 的 Map<String,Object>
     * @throws Exception 业务或编码异常
     */
    Map<String, Object> handleAnnounce(
            byte[] infoHash,
            byte[] peerId,
            int port,
            long uploaded,
            long downloaded,
            long left,
            String event,
            String passkey,
            String ip
    ) throws Exception;

    /**
     * 将一个 Map<String,Object> 编码成 bencode 二进制
     */
    byte[] encodeBencode(Map<String, Object> reply) throws IOException;
}
