package com.ruoyi.tracker.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.tracker.mapper.TrackerProjectMapper;
import com.ruoyi.tracker.domain.TrackerProject;
import com.ruoyi.tracker.service.ITrackerProjectService;

/**
 * 项目Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
@Service
public class TrackerProjectServiceImpl implements ITrackerProjectService 
{
    @Autowired
    private TrackerProjectMapper trackerProjectMapper;

    /**
     * 查询项目
     * 
     * @param projectId 项目主键
     * @return 项目
     */
    @Override
    public TrackerProject selectTrackerProjectByProjectId(Long projectId)
    {
        return trackerProjectMapper.selectTrackerProjectByProjectId(projectId);
    }

    /**
     * 查询项目列表
     * 
     * @param trackerProject 项目
     * @return 项目
     */
    @Override
    public List<TrackerProject> selectTrackerProjectList(TrackerProject trackerProject)
    {
        return trackerProjectMapper.selectTrackerProjectList(trackerProject);
    }

    /**
     * 新增项目
     * 
     * @param trackerProject 项目
     * @return 结果
     */
    @Override
    public int insertTrackerProject(TrackerProject trackerProject)
    {
        trackerProject.setCreateTime(DateUtils.getNowDate());
        return trackerProjectMapper.insertTrackerProject(trackerProject);
    }

    /**
     * 修改项目
     * 
     * @param trackerProject 项目
     * @return 结果
     */
    @Override
    public int updateTrackerProject(TrackerProject trackerProject)
    {
        trackerProject.setUpdateTime(DateUtils.getNowDate());
        return trackerProjectMapper.updateTrackerProject(trackerProject);
    }

    /**
     * 批量删除项目
     * 
     * @param projectIds 需要删除的项目主键
     * @return 结果
     */
    @Override
    public int deleteTrackerProjectByProjectIds(Long[] projectIds)
    {
        return trackerProjectMapper.deleteTrackerProjectByProjectIds(projectIds);
    }

    /**
     * 删除项目信息
     * 
     * @param projectId 项目主键
     * @return 结果
     */
    @Override
    public int deleteTrackerProjectByProjectId(Long projectId)
    {
        return trackerProjectMapper.deleteTrackerProjectByProjectId(projectId);
    }
}
