package com.ruoyi.announce.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

public class BencodeEncoder {

    public byte[] encodeBencode(Map<String, Object> reply) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        encodeMap(reply, outputStream);
        return outputStream.toByteArray();
    }

    private void encodeMap(Map<String, Object> map, ByteArrayOutputStream outputStream) throws IOException {
        outputStream.write('d'); // Start of a dictionary

        for (Map.Entry<String, Object> entry : map.entrySet()) {
            encodeString(entry.getKey(), outputStream); // Encode key
            encodeObject(entry.getValue(), outputStream); // Encode value
        }

        outputStream.write('e'); // End of a dictionary
    }

    private void encodeObject(Object obj, ByteArrayOutputStream outputStream) throws IOException {
        if (obj instanceof Integer) {
            encodeInteger((Integer) obj, outputStream);
        } else if (obj instanceof String) {
            encodeString((String) obj, outputStream);
        } else if (obj instanceof Map) {
            encodeMap((Map<String, Object>) obj, outputStream);
        } else if (obj instanceof Iterable) {
            encodeList((Iterable<Object>) obj, outputStream);
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + obj.getClass());
        }
    }

    private void encodeInteger(Integer value, ByteArrayOutputStream outputStream) throws IOException {
        outputStream.write('i');
        outputStream.write(value.toString().getBytes());
        outputStream.write('e');
    }

    private void encodeString(String value, ByteArrayOutputStream outputStream) throws IOException {
        outputStream.write(Integer.toString(value.length()).getBytes());
        outputStream.write(':');
        outputStream.write(value.getBytes());
    }

    private void encodeList(Iterable<Object> list, ByteArrayOutputStream outputStream) throws IOException {
        outputStream.write('l'); // Start of a list

        for (Object item : list) {
            encodeObject(item, outputStream);
        }

        outputStream.write('e'); // End of a list
    }
}
