package com.ruoyi.torrent.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.torrent.mapper.BtTorrentMapper;
import com.ruoyi.torrent.domain.BtTorrent;
import com.ruoyi.torrent.service.IBtTorrentService;

/**
 * 种子主Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@Service
public class BtTorrentServiceImpl implements IBtTorrentService 
{
    @Autowired
    private BtTorrentMapper btTorrentMapper;

    /**
     * 查询种子主
     * 
     * @param torrentId 种子主主键
     * @return 种子主
     */
    @Override
    public BtTorrent selectBtTorrentByTorrentId(Long torrentId)
    {
        return btTorrentMapper.selectBtTorrentByTorrentId(torrentId);
    }

    /**
     * 查询种子主列表
     * 
     * @param btTorrent 种子主
     * @return 种子主
     */
    @Override
    public List<BtTorrent> selectBtTorrentList(BtTorrent btTorrent)
    {
        return btTorrentMapper.selectBtTorrentList(btTorrent);
    }

    /**
     * 新增种子主
     * 
     * @param btTorrent 种子主
     * @return 结果
     */
    @Override
    public int insertBtTorrent(BtTorrent btTorrent)
    {
        return btTorrentMapper.insertBtTorrent(btTorrent);
    }

    /**
     * 修改种子主
     * 
     * @param btTorrent 种子主
     * @return 结果
     */
    @Override
    public int updateBtTorrent(BtTorrent btTorrent)
    {
        return btTorrentMapper.updateBtTorrent(btTorrent);
    }

    /**
     * 批量删除种子主
     * 
     * @param torrentIds 需要删除的种子主主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentByTorrentIds(Long[] torrentIds)
    {
        return btTorrentMapper.deleteBtTorrentByTorrentIds(torrentIds);
    }

    /**
     * 删除种子主信息
     * 
     * @param torrentId 种子主主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentByTorrentId(Long torrentId)
    {
        return btTorrentMapper.deleteBtTorrentByTorrentId(torrentId);
    }
}
