package com.ruoyi.tracker.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.tracker.mapper.TrackerProjectUserMapper;
import com.ruoyi.tracker.domain.TrackerProjectUser;
import com.ruoyi.tracker.service.ITrackerProjectUserService;

/**
 * 项目与用户关联Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
@Service
public class TrackerProjectUserServiceImpl implements ITrackerProjectUserService 
{
    @Autowired
    private TrackerProjectUserMapper trackerProjectUserMapper;

    /**
     * 查询项目与用户关联
     * 
     * @param projectId 项目与用户关联主键
     * @return 项目与用户关联
     */
    @Override
    public TrackerProjectUser selectTrackerProjectUserByProjectId(Long projectId)
    {
        return trackerProjectUserMapper.selectTrackerProjectUserByProjectId(projectId);
    }

    /**
     * 查询项目与用户关联列表
     * 
     * @param trackerProjectUser 项目与用户关联
     * @return 项目与用户关联
     */
    @Override
    public List<TrackerProjectUser> selectTrackerProjectUserList(TrackerProjectUser trackerProjectUser)
    {
        return trackerProjectUserMapper.selectTrackerProjectUserList(trackerProjectUser);
    }

    /**
     * 新增项目与用户关联
     * 
     * @param trackerProjectUser 项目与用户关联
     * @return 结果
     */
    @Override
    public int insertTrackerProjectUser(TrackerProjectUser trackerProjectUser)
    {
        trackerProjectUser.setCreateTime(DateUtils.getNowDate());
        return trackerProjectUserMapper.insertTrackerProjectUser(trackerProjectUser);
    }

    /**
     * 修改项目与用户关联
     * 
     * @param trackerProjectUser 项目与用户关联
     * @return 结果
     */
    @Override
    public int updateTrackerProjectUser(TrackerProjectUser trackerProjectUser)
    {
        return trackerProjectUserMapper.updateTrackerProjectUser(trackerProjectUser);
    }

    /**
     * 批量删除项目与用户关联
     * 
     * @param projectIds 需要删除的项目与用户关联主键
     * @return 结果
     */
    @Override
    public int deleteTrackerProjectUserByProjectIds(Long[] projectIds)
    {
        return trackerProjectUserMapper.deleteTrackerProjectUserByProjectIds(projectIds);
    }

    /**
     * 删除项目与用户关联信息
     * 
     * @param projectId 项目与用户关联主键
     * @return 结果
     */
    @Override
    public int deleteTrackerProjectUserByProjectId(Long projectId)
    {
        return trackerProjectUserMapper.deleteTrackerProjectUserByProjectId(projectId);
    }
}
